package editor;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ListedCustomImage  {
	
	private String fileName;
	
	private BufferedImage rawImage;
	private int width, height;
	
	private Color transColor;
	private ImageObserver myObserver;
	
	public ListedCustomImage(BufferedImage theImage, int desiredWidth, int desiredHeight, Color transparentColor, ImageObserver obs, String origFileName) {
		
		fileName = origFileName;
		rawImage = theImage;
		transColor = transparentColor;
		width = desiredWidth;
		height = desiredHeight;
		myObserver = obs;
		
	}
	

	public String toString() {
		if(fileName == null) {
			return null;
		}
		
		int index = Math.max(fileName.lastIndexOf('\\'), fileName.lastIndexOf('/'));
		
		if(index == -1 || index == (fileName.length() - 1))
			return fileName;
		else
			return fileName.substring(index + 1);
		
		
	}


	public String getFileName() {
		return fileName;
	}


	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
	public void setTransparentColor(Color newColor) {
		this.transColor = newColor;
	}
	
	public static ListedCustomImage letUserSelectImage(String title, JDialog parent, ImageObserver io) {
		
		ListedCustomImage returnValue = new ListedCustomImage(null,0,0,null,null, null);
		
		FileDialog fd = new FileDialog(parent, title, FileDialog.LOAD);
		
//		System.out.println("about to called fd.setVisible...will it work?");
		
		fd.setVisible(true);
		
//		System.out.println("it just returned from fd.setVisible...file is:  <<" + fd.getFile() + ">>, directory is: <<" + fd.getDirectory() + ">>");
		
		if(fd.getFile() == null || fd.getDirectory() == null) {
//			System.out.println("user clicked cancel!");
			return null;
		}
		
		String fullFileName = fd.getDirectory() + fd.getFile();
		
		BufferedImage theImage = null;
		
		File theFile = new File(fullFileName);
		
		if(!theFile.exists()) {
//			System.out.println("file doesn't exist...I should really add a 'hey doofus!' dialog for this one...");
			
			JOptionPane.showMessageDialog(null, "The specified file did not exist.", "File Error", JOptionPane.ERROR_MESSAGE);
			
			return null;
		}
		
		try {
			theImage = ImageIO.read(theFile);
		} catch (IOException e) {
			// TODO add a dialog to this one.
//			e.printStackTrace();
			
//			System.err.println("there was an IOException while reading this pooch...");
			JOptionPane.showMessageDialog(null, "Error while reading file:  " + e.getMessage(), "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(theImage == null) {
			JOptionPane.showMessageDialog(null, "The given file was not a readable image format:  " + fullFileName, "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		returnValue.setRawImage(theImage);
		returnValue.setFileName(fullFileName);
		
		returnValue.setWidth(theImage.getWidth(io));
		returnValue.setHeight(theImage.getHeight(io));
		
		
		return returnValue;
		
	}
	
	public void setRawImage(BufferedImage theImage) {
		this.rawImage = theImage;
	}
	
	public void setWidth(int newWidth) {
		this.width = newWidth;
	}
	
	public void setHeight(int newHeight) {
		this.height = newHeight;
	}


	public BufferedImage getImage() {
		return rawImage;
	}


	public int getDesiredWidth() {
		return width;
	}


	public int getDesiredHeight() {
		return height;
	}


	public Color getTransparentColor() {
		return transColor;
	}
	
	public ImageObserver getObserver() {
		return myObserver;
	}
}
